# -*- coding: utf-8 -*-
"""
Created on Thu Nov 17 10:31:04 2022

@author: Wassie
"""

import cv2
import gym
import highway_env
import numpy as np
from matplotlib import pyplot as plt
#%matplotlib qt


# Setting the frame size for the video output. 
#In general this should be equal to the screen environments settings later on.
frameSize = (640, 280)

# Creating a VideoWriter to convert images to a video format. 
# Four parameters to set in general, in order:
# 1. Filename (+ optional path) : 'video-test-1.avi'  
# 2. Video file extension: default 'cv2.VideoWriter_fourcc(*'DIVX')' for AVI 
#alternatively MP4 can be used as video file extension
# 3. FPS (int) : the amount of frames per second
# 4. frameSize : video stream size
out = cv2.VideoWriter('video-test-1.avi',cv2.VideoWriter_fourcc(*'DIVX'), 4, frameSize)

# Creating a default highway lanes scenario
env = gym.make('highway-v0')
# Setting the Highway Environment (pygame setting) screen parameters. 
# Look at the 'envs' folder https://github.com/eleurent/highway-env/tree/master/highway_env/envs
# search for 'screen_width' and 'screen_height' for the Environment you want to use and set this accordingly
env.configure({
    "screen_width": 640,
    "screen_height": 280
})

# Clear old Environment settings and set step counter to 0.
env.reset()


for f in range(40):
    action = env.action_type.actions_indexes["IDLE"]
    #Moving to the next step in the simulation environment
    obs, reward, done, truncated, info = env.step(action)
    #Render the next image 
    env.render()
    #Temporarily store a RGB 3D array of the current pygame frame
    cur_frame = env.render(mode="rgb_array")
    #Provide the stored frame to the VideoWriter, effectively appending this image.
    out.write(cur_frame)

# Finalize the video. Note: only AFTER this line it becomes a fully functional video file.
out.release()

print('done')


